instrreset  %desconecta todos los instrumentos
close all
clear
clc

%% generates a port for the WiFi connection
UDPComIn=udp('192.168.0.101','LocalPort',12345); 
set(UDPComIn,'DatagramTerminateMode','off');

%% code for generate the graphic
x=-2:0.1:2; %create a -2 to 2 vector in x
y=-2:0.1:2; %create a -2 to 2 vector in y
[X,Y]=meshgrid(x,y);    %create a mesh with the create vectors
Z=X.*exp(-X.^2-Y.^2);   %function wiht the vectors
h=surf(X,Y,Z);          %graphic the function

%% data entry and manipulation
while 1
    fopen(UDPComIn);    %create a file type csv in blank
    csvdata=fscanf(UDPComIn);   %Read data from instrument, and format as text
    scandata=textscan(csvdata,'%s %f %f %f %f %f','Delimiter',','); %separate all the data with comma
    data=[scandata{4},scandata{5},scandata{6}];     %separete the 4,5 and 6 dates
    
    rotate(h,[1 0 0],data(1,1));    % use the code to rotate the graphic
    rotate(h,[0 1 0],data(1,3));
    pause(0.0001)       % pause the program to show the graphic
    
    fclose(UDPComIn);
end
